<?php
/**
 * Avalex System Plugin
 *
 * @author     avalex GmbH
 * @package   Avalex
 * @copyright Copyright 2018-03-20 11:25:56
 * @license   GNU Public License
 * @link      http://avalex.de
 */


defined('JPATH_PLATFORM') or die;

use Joomla\Registry\Registry;

JFormHelper::loadFieldClass('text');

/**
 * Form Field class for  avalex GmbH Joomla! Extensions.
 * Provides a clicklegal code check.
 * JFormFieldText
 */
class JFormFieldClicklegalCodeCheck extends JFormFieldText
{
    protected $type = 'clicklegalcodecheck';

    protected function getInput()
    {
        $field_set = $this->form->getFieldset();
        $apikey = '';

        $domain = 'https://avalex.de/api_keys/is_configured.json';

        $apikey = $this->value;
        if ($apikey === '') {
            return parent::getInput();
        }

        //$this->id = 'jform_params_apikey'

        $session = JFactory::getSession();

        $this->addHeadData();

        $session->clear('field_value', 'clicklegalcodecheck');

        $field_value_session = $session->get('field_value', '', 'clicklegalcodecheck');

        $apikey_session = $session->get('apikey', '', 'clicklegalcodecheck');

        $session->clear('field_value', 'clicklegalcodecheck');
        $session->clear('apikey', 'clicklegalcodecheck');

        $session->set('apikey', $apikey, 'clicklegalcodecheck');

        $apikey_mess = $apikey_check = null;
        $apikey_ress = $this->getClicklegalCodeStatus($domain, $apikey);
        //$apikey_check = -2;
        if (is_array($apikey_ress)) {
            $apikey_check = array_shift($apikey_ress);
            if (is_array($apikey_ress)) {
                $apikey_mess = current($apikey_ress);
            }
        } elseif (is_numeric($apikey_ress)) {
            $apikey_check = $apikey_ress;
        }

        if ($apikey_check !== 1) {
            $error = 'error';
            $text = JText::sprintf('PLG_AVALEX_APIKEY_CHECK_DEFAULT_ERROR', $apikey);

            if ($apikey_check === -1) {
                $text = JText::_('PLG_AVALEX_APIKEY_CHECK_ERROR_SERVER');
                $error = 'warning';
            }

            if ($apikey_check === -2) {
                $text = JText::_('PLG_AVALEX_APIKEY_CHECK_ERROR');
                $error = 'warning';
            }

            if ($apikey_mess) {
                $text = $apikey_mess;
            }

            $field_value = $this->setInput($text, $error);

            $session->set('field_value', $field_value, 'clicklegalcodecheck');

            return $field_value;
        }

        $field_value = '';

        if ($this->id == 'jform_params_apikey' or $this->id == 'jform_apikey') {
            $text = JText::_('PLG_AVALEX_APIKEY_CHECK_SUCCESS');
            if ($apikey_mess) {
                $text = $apikey_mess;
            }
            $field_value .= $this->setInput($text, 'success');
        }

        $session->set('field_value', 1, 'clicklegalcodecheck');

        return $field_value;
    }

    /**
     * Check the entered clicklegal code with the validation script that is located on a main and a fall back server
     *
     * @param $host
     * @param $apikey
     *
     * @return int|string
     */
    private function getClicklegalCodeStatus($host, $apikey)
    {
        $domain = 'https://avalex.de/api_keys/is_configured.json';
        $apikey_check = 0;
        $apikey_mess = JText::sprintf('PLG_AVALEX_APIKEY_CHECK_DEFAULT_ERROR', $apikey);

        $url = $host . '?apikey=' . rawurlencode($apikey);

        if (JHttpFactory::getAvailableDriver(new Registry) == false) {
            $apikey_mess = JText::_('PLG_AVALEX_APIKEY_CHECK_ERROR');
            return array(-2, $apikey_mess);
        }

        if (!empty($host) and !empty($apikey)) {
            // First try it with the main validation server and with HTTPS
            $url_check = $url;

            try {
                $apikey_request = JHttpFactory::getHttp()->get($url_check);
            } catch (Exception $e) {
                $apikey_mess = JText::_('PLG_AVALEX_APIKEY_CHECK_ERROR_SERVER');
                return array(-1, $apikey_mess);
                //return -1;
            }

            if (empty($apikey_request->body)) {
                $apikey_mess = JText::sprintf('PLG_AVALEX_APIKEY_CHECK_DEFAULT_ERROR', $apikey);
                $apikey_check = -3;
                return array(-3, $apikey_mess);
            }

            /**JHttpResponse::__set_state(array( 'code' => 200, 'headers' => array ( 'Date' => 'Mon, 19 Mar 2018 14:33:56 GMT', 'Server' => 'Apache', 'Set-Cookie' => 'CAKEPHP=04d38d26b08aca5392fa9d6aaa6f4aa7; expires=Mon, 19-Mar-2018 18:33:56 GMT; Max-Age=14400; path=/; secure; HttpOnly', 'Upgrade' => 'h2,h2c', 'Connection' => 'Upgrade', 'Content-Length' => '36', 'Content-Type' => 'application/json; charset=UTF-8', ), 'body' => '{"message":"OK","domain":"l-one.de"}', )) */

            $data = json_decode($apikey_request->body, true);

            $currentHost = JUri::getInstance()->getHost();

            if ($apikey_request->code == 200) {
                $avalex_domain = $check_domain = false;
                if (isset($data['domain'])) {
                    $avalex_domain = ($data['domain']);
                    if (strpos($currentHost, $avalex_domain) !== false) {
                        $check_domain = true;
                    }
                }

                $is_localhost = (bool) ($currentHost == 'localhost' || $currentHost == '127.0.0.1');

                if (($check_domain || $is_localhost)) {
                    // do not show error
                } else {

                    // clear all data - for wrong domain
                    $db = JFactory::getDbo();

                    try {
                        $query = $db->getQuery(true)
                            ->delete($db->quoteName('#__avalex'))
                            ->where('1');
                        $db->setQuery($query);
                        $db->execute();
                    } catch (Exception $e) {
                        return false;
                    }

                    $apikey_mess = JText::sprintf('PLG_AVALEX_APIKEY_CHECK_DOMAIN_ERROR', $avalex_domain);
                    return array(-4, $apikey_mess);
                }
            }

            if ($apikey_request->code == 200) {
                $this->get_avalex_data($apikey);
                $apikey_check = 1;
                $apikey_mess = JText::_('PLG_AVALEX_APIKEY_CHECK_SUCCESS');
                return array($apikey_check, $apikey_mess);
            }
        }

        return array($apikey_check, $apikey_mess);
    }

    private function get_avalex_data($apikey)
    {
        $domain = 'https://avalex.de/datenschutzerklaerung';
        // generate url
        $params = http_build_query(array(
            'apikey' => $apikey,
        ), '', '&');

        $url_check = $domain . '?' . $params;

        try {
            $apikey_request = JHttpFactory::getHttp()->get($url_check);
        } catch (Exception $e) {
            return -1;
        }
        if ($apikey_request->code == 200 && !empty($apikey_request->body)) {
            $data = $apikey_request->body;

            $now = JFactory::getDate();
            if (version_compare(JVERSION, '3.0', 'ge')) {
                $cron_time = $now->toSql();
            } else {
                $cron_time = $now->toMysql();
            }
            $jarticle = new stdClass();
            $jarticle->cron_time = $cron_time;
            $jarticle->api_key = $apikey;
            $jarticle->avalex_data = $apikey_request->body;

            $db = JFactory::getDbo();

            //->where($db->quoteName('api_key') . ' = ' . $db->quote($apikey));
            try {
                $query = $db->getQuery(true)
                    ->delete($db->quoteName('#__avalex'))
                    ->where('1');
                $db->setQuery($query);
                $db->execute();
            } catch (Exception $e) {
                return false;
            }

            try {
                $query = $db->getQuery(true);
                $result = JFactory::getDbo()->insertObject('#__avalex', $jarticle);
            } catch (Exception $e) {
                //$result = JFactory::getDbo()->updateObject('#__avalex', $jarticle, 'api_key');
                return false;
            }
        }
    }

    /**
     * Creates random classes for the div containers
     *
     * @param        $session
     * @param string $type
     *
     * @return string
     */
    private function headData($type = 'error')
    {
        $head_data = '<style type="text/css"><!--

		.avalex {padding-right: 20.5px!important;}
		.controls{
		position: relative;

		}
		#cliizyb{
		 padding:0;padding-top:5px;
		 position: absolute!important;
		 z-index: 102!important;
		 width: 99%!important;
		}

		#hidestpmes{width: 240px;position: relative;}
		#jform_params_apikey{width: 210px;}

		.avalex-feedback {
			right: 15px;
		}

		span.icon-notification {
			color: #993300;
		}

		.avalex-feedback {
			position: absolute!important;
			top: -30px!important;
			right: 0!important;
			z-index: 2!important;
			display: block!important;
			width: 34px!important;
			height: 34px!important;
			line-height: 34px!important;
			text-align: center!important;
			pointer-events: none!important;
		}
		--></style>';
        $head_data .= '<script type="text/javascript"><!--
jQuery(document).ready(function($) {
   $("#jform_params_apikey").keyup(function() {
      $("#hideallaval").hide();
  })
});
//--></script>';

        return $head_data;
    }

    private function setInput($text = '', $type = 'error')
    {
        $html = parent::getInput();

        $res = '';
        $icon = '<span class="icon-publish avalex-feedback">&nbsp;</span>';
        $css = 'color: #008002;';
        if ($type == 'error') {
            $icon = '<span class="icon-unpublish avalex-feedback">&nbsp;</span>';
            $css = 'color: #ff0033;';
        } elseif ($type == 'success') {
            $icon = '<span class="icon-publish avalex-feedback">&nbsp;</span>';
            $css = 'color: #008002;';
        } elseif ($type == 'warning') {
            $icon = '<span class="icon-notification avalex-feedback">&nbsp;</span>';
            $css = 'color: #8a6d3b;';
        }
        if ($text) {
            $res = '<div id="cliizyb" class="cliizyb" style="' . $css . '">' . $text . '</div><div class="clearfix"></div>';
        }

        $html = $html . '<div id="hideallaval"><div id="hidestpmes">' . $icon . '</div>' . $res . '</div>';

        return $html;
    }

    /**
     * Add the style data to the head
     *
     * @param $data
     */
    private function addHeadData($data = null)
    {
        static $data_loaded = false;

        if (empty($data_loaded)) {
            if (is_null($data)) {
                $data = $this->headData();
            }
            $document = JFactory::getDocument();
            $document->addCustomTag($data);

            $data_loaded = true;
        }
    }
} //end class
